<?php
header('Content-Type: application/json');
include "../config/koneksi.php";

// =========================
// AMBIL INPUT JSON / FORM
// =========================
$raw  = file_get_contents("php://input");
$json = json_decode($raw, true);

$email    = $_POST['email'] ?? ($json['email'] ?? '');
$password = $_POST['password'] ?? ($json['password'] ?? '');

$email = trim(strtolower($email));

if ($email === '' || $password === '') {
    echo json_encode([
        "status"  => false,
        "message" => "Email dan password wajib diisi"
    ]);
    exit;
}

// =========================
// QUERY USER
// =========================
$stmt = $conn->prepare("
    SELECT 
        u.id,
        u.nama,
        u.email,
        u.password,
        u.foto,
        r.nama_role,
        j.nama_jabatan,
        f.nama_fraksi,
        k.nama_komisi
    FROM user u
    LEFT JOIN role r ON u.role_id = r.id
    LEFT JOIN jabatan j ON u.jabatan_id = j.id
    LEFT JOIN fraksi f ON u.fraksi_id = f.id
    LEFT JOIN komisi k ON u.komisi_id = k.id
    WHERE u.email = ?
    LIMIT 1
");

$stmt->bind_param("s", $email);
$stmt->execute();

// =========================
// BIND RESULT (ANTI 500)
// =========================
$stmt->bind_result(
    $id,
    $nama,
    $emailDb,
    $passwordDb,
    $foto,
    $role,
    $jabatan,
    $fraksi,
    $komisi
);

if (!$stmt->fetch()) {
    echo json_encode([
        "status"  => false,
        "message" => "Email tidak ditemukan"
    ]);
    exit;
}

$stmt->close();

// =========================
// CEK PASSWORD (PLAIN TEXT)
// =========================
if (!password_verify($password, $passwordDb)) {
    echo json_encode([
        "status"  => false,
        "message" => "Password salah"
    ]);
    exit;
}


// =========================
// AMBIL AKD (MULTI)
// =========================
$akd = [];
$akdQ = $conn->prepare("
    SELECT a.nama_akd
    FROM user_akd ua
    JOIN akd a ON ua.akd_id = a.id
    WHERE ua.user_id = ?
");
$akdQ->bind_param("i", $id);
$akdQ->execute();
$akdQ->bind_result($namaAkd);

while ($akdQ->fetch()) {
    $akd[] = $namaAkd;
}
$akdQ->close();

// =========================
// RESPONSE
// =========================
echo json_encode([
    "status"  => true,
    "message" => "Login berhasil",
    "user" => [
        "id"      => (int)$id,
        "nama"    => $nama,
        "email"   => $emailDb,
        "role"    => $role,
        "jabatan" => $jabatan,
        "fraksi"  => $fraksi,
        "komisi"  => $komisi,
        "akd"     => $akd,
        "foto"    => !empty($foto)
            ? "https://applaunch.my.id/uploads/user/" . $foto
            : null
    ]
]);
