<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

include __DIR__ . "/../config/koneksi.php";

// =======================
// QUERY USER FRAKSI GOLKAR
// =======================
$sql = "
    SELECT 
        u.id,
        u.nama,
        IFNULL(j.nama_jabatan, '-') AS jabatan,
        IFNULL(f.nama_fraksi, '-') AS fraksi,
        IFNULL(u.foto, '') AS foto
    FROM user u
    LEFT JOIN jabatan j ON u.jabatan_id = j.id
    LEFT JOIN fraksi f ON u.fraksi_id = f.id
    WHERE LOWER(f.nama_fraksi) = 'pdi perjuangan'
    ORDER BY u.nama ASC
";

$q = mysqli_query($conn, $sql);

if (!$q) {
    echo json_encode([
        "status" => false,
        "message" => "Query error",
        "error" => mysqli_error($conn),
        "data" => []
    ]);
    exit;
}

$data = [];
while ($row = mysqli_fetch_assoc($q)) {
    $data[] = $row;
}

echo json_encode([
    "status" => true,
    "total" => count($data),
    "data" => $data
]);
