<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

include __DIR__ . "/../config/koneksi.php";

$sql = "
SELECT 
    u.id,
    u.nama,
    u.foto,
    j.nama_jabatan AS jabatan,
    f.nama_fraksi AS fraksi,
    k.nama_komisi AS komisi,
    GROUP_CONCAT(a.nama_akd SEPARATOR ', ') AS akd
FROM user u
LEFT JOIN jabatan j ON u.jabatan_id = j.id
LEFT JOIN fraksi f ON u.fraksi_id = f.id
LEFT JOIN komisi k ON u.komisi_id = k.id
LEFT JOIN user_akd ua ON ua.user_id = u.id
LEFT JOIN akd a ON a.id = ua.akd_id

-- ⛔ EXCLUDE ADMIN & SUPER ADMIN
WHERE j.nama_jabatan NOT IN ('sekwan', 'super admin')

GROUP BY u.id
";

$q = $conn->query($sql);

if (!$q) {
    echo json_encode([
        "status" => false,
        "error" => $conn->error
    ]);
    exit;
}

$data = [];
while ($r = $q->fetch_assoc()) {
    $data[] = $r;
}

echo json_encode([
    "status" => true,
    "data" => $data
]);
